/*******************************************************************************
 * Copyright (c) 2009, 2010 Ericsson
 *
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Francois Chouinard - Initial API and implementation
 *******************************************************************************/

package org.eclipse.linuxtools.tmf.tests.stubs.request;

import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.request.TmfDataRequest;

/**
 * @param <T> The event type
 */
public class TmfDataRequestStub<T extends TmfEvent> extends TmfDataRequest<T> {

    /**
     * Default constructor
     *
     * @param dataType the request data type
     */
    public TmfDataRequestStub(final Class<T> dataType) {
        super(dataType);
    }

    /**
     * @param dataType the request data type
     * @param index the initial event index
     */
    public TmfDataRequestStub(final Class<T> dataType, final int index) {
        super(dataType, index);
    }

    /**
     * @param dataType the request data type
     * @param index the initial event index
     * @param nbRequested the number of events requested
     */
    public TmfDataRequestStub(final Class<T> dataType, final int index, final int nbRequested) {
        super(dataType, index, nbRequested);
    }

    /**
     * @param dataType the request data type
     * @param index the initial event index
     * @param nbRequested the number of events requested
     * @param blockSize the event block size
     */
    public TmfDataRequestStub(final Class<T> dataType, final int index, final int nbRequested, final int blockSize) {
        super(dataType, index, nbRequested, blockSize);
    }

    /* (non-Javadoc)
     * @see org.eclipse.linuxtools.tmf.core.request.TmfDataRequest#handleData(org.eclipse.linuxtools.tmf.core.event.ITmfEvent)
     */
    @Override
    public void handleData(final T data) {
        super.handleData(data);
    }

}
